<?php

namespace Modules\Playground\Controllers;

use App\Helpers\ApiResponse;
use App\Http\Requests\Admin\Playgrounds\Store;
use Illuminate\Http\Request;
use Modules\Areas\Models\Area;
use Modules\Common\Controllers\Admin\HelperController;
use Modules\Playground\Models\Playground;
use MshMsh\Helpers\ApiResponder;

class AdminController extends HelperController
{
    public function __construct()
    {
        $this->model = new Playground();
        $this->rows = $this->model->with('area');

        $this->title = "Playground";
        $this->name = 'playgrounds';
        $this->has_map = true;
        $this->formRequest = Store::class;
        $this->switches['status'] = route('admin.playgrounds.active_status');
    }

    public function listBuilder()
    {
        $this->list = [
            'name' => __('title'),
            'area_name' => __('area'),
        ];
    }

    public function formBuilder()
    {
        $areas = Area::pluck('name','id')->toArray();
        $this->inputs = [
            'name' => ['title' => __('title')],
            'area_id' => ['title' => __('area'),'type'=>'select','values'=>$areas],
        ];
    }
    public function active_status(Request $request)
    {
        $playground = Playground::findOrFail($request->id);
        $playground->update(['status' => !$playground->status]);
        return ApiResponse::get( '', ['status' => 1]);
    }
}
