<?php

namespace Modules\Pages\Models;

use App\Traits\DefaultMediaImage;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Page extends Model implements HasMedia
{
    use InteractsWithMedia,DefaultMediaImage;
    protected $fillable = [
        'title',
        'content',
        'type',
        'image'
    ];
    protected $hidden = ['created_at', 'updated_at'];

    public function setImageAttribute($image)
    {
        if (is_uploaded_file($image)) {
            $this->clearMediaCollection('image');
            $this->addMediaFromRequest('image')
                ->toMediaCollection('image');
        }
    }
    public function getImageAttribute()
    {
        $this::$defaultImage = '/placeholders/item.png';
        return $this->getFirstOrDefaultMediaUrl('image');
    }
    public function getLinkAttribute(){
        return route('pages.show' , $this->slug);
    }
}
