<?php

use Illuminate\Support\Facades\Route;
use Modules\Messages\Controllers\ApiController;

Route::group([
    'middleware' => ['auth:sanctum', 'auth-check'],
    'prefix' => 'messages',
], function () {
    Route::post('/send', [ApiController::class, 'sendMessage']);
    Route::get('/team/{teamId}', [ApiController::class, 'getTeamMessages']);
    Route::post('/delete/{messageId}', [ApiController::class, 'deleteMessage']);
});
