@extends('Common::admin.layout.page')

@section('page')
    <div class="row">
        <div class="col-sm-12">
            <!-- general form elements -->
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">
                        {{ __('show details') }}
                    </h3>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-stripped">
                        <tbody>
                        <tr>
                            <th>{{ __('playground') }}</th>
                            <td>{{ $match->playground?->name }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('date') }}</th>
                            <td>{{ $match->date }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('start time') }}</th>
                            <td>{{ $match->start_time }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('end time') }}</th>
                            <td>{{ $match->end_time }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('subscribers') }}</th>
                            <td>{{ $match->subscribers_qty }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('amount') }}</th>
                            <td>{{ $match->amount }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('details') }}</th>
                            <td>{{ $match->details }}</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-sm-12">
            <!-- general form elements -->
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">
                        {{ __('subscribers') }}
                    </h3>
                </div>
                <div class="card-body">
                    <div class="add-subscriber my-4">
                        <form action="{{ route('admin.matches.subscribe',$match->id) }}" method="post" class="action_form" novalidate>
                            <div class="row">
                                <div class="col-sm-10">
                                    <x-input :input="$input" :name="$input['name']" :model="$model" lang="" />
                                </div>
                                <div class="col-sm-2">
                                    <button type="submit" style="margin-top: 2rem;" class="btn btn-primary">{{__('send')}}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <table class="table table-bordered table-stripped">
                        <tbody>
                        <tr>
                            <th>{{ __('name') }}</th>
                            <th>{{ __('mobile') }}</th>
                            <th>{{ __('status') }}</th>
                            <th>{{ __('presence') }}</th>
                            <th>{{ __('created at') }}</th>
                            <th>{{ __('Delete') }}</th>
                        </tr>
                        @if($match->subscriber_lists()->count() > 0)
                        @foreach($match->subscriber_lists as $subscriber)
                            <tr>
                                <td>
                                    {{$subscriber->user?->name ?? $subscriber->name}}
                                </td>
                                <td>
                                    {{$subscriber->user->full_phone ?? $subscriber->phone}}
                                </td>
                                <td>
                                    {{__($subscriber->status)}}
                                </td>
                                <td>
                                    {{$subscriber->presence ? __('presence') : __('absence')}}
                                </td>
                                <td>
                                    {{$subscriber->created_at}}
                                </td>
                                <td>
                                    <form action="{{ route("admin.subscribers.destroy", $subscriber->id) }}" method="post"
                                          class="action_form remove">
                                        @csrf
                                        {{ method_field('delete') }}
                                        <button type="submit" class="btn btn-danger removethis">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                        @else
                            <tr>
                                <td colspan="5">{{__('there is no data')}}</td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop
