<?php

use Modules\Match\Controllers\ApiController;

Route::get('matches/{id}', [ApiController::class, 'show']);
Route::get('subscribers/{id}', [ApiController::class, 'subscribersList']);
Route::get('subscriber/{id}', [ApiController::class, 'subscriber']);


Route::group(['middleware' => ['auth:sanctum', 'auth-check']], function () {
    Route::resource('matches', ApiController::class)->only('store', 'update', 'destroy');
    Route::get('my-matches', [ApiController::class, 'myMatches']);

    Route::post('presence/{id}', [ApiController::class, 'presence']);
    Route::post('add_subscriber', [ApiController::class, 'add_subscriber']);
    Route::post('subscribe', [ApiController::class, 'subscribe']);
    Route::post('cancel', [ApiController::class, 'cancel']);
    Route::get('all-challange-Matches', [ApiController::class, 'allChallangeMatches']);
    Route::get('challenges-index', [ApiController::class, 'challengesIndex']);
});
