<?php

namespace Modules\Match\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class SingleSubscriberResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  $this->id,
            'image'    =>  (string) $this->image,
            'name'    =>  (string) $this->name,
            'location'    =>  (string) $this->location?->name,
            'phone'    =>  (string) $this->full_phone,
            'city'    =>  (string) $this->area?->name,
        ];
    }
}
