<?php

namespace Modules\Match\Resources;

use App\Enum\MatchType;
use App\Enum\SubscriberStatus;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class SingleMatcheResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  $this->id,
            'playground'    =>  (string) $this->playground?->name,
            'playground_id'    =>  (int) $this->playground_id,
            'durations_text'    =>  (string) $this->durations_text,
            'durations'    =>  (int) $this->durations,
            'subscribers_count'    =>  (string) (($this->type == MatchType::GROUP ? $this->subscriber_lists_count : $this->subscribers_count).'/'.$this->subscribers_qty),
            'date'    =>  Carbon::parse($this->date)->translatedFormat('l Y-m-d'),
            'start_time'    =>  Carbon::parse($this->start_time)->translatedFormat('h:i a'),
            'end_time'    =>  Carbon::parse($this->end_time)->translatedFormat('h:i a'),
            'data_date' =>[
                'date'    =>  $this->date,
                'start_time'    =>  $this->start_time,
                'end_time'    => $this->end_time,
            ],
            'amount'    =>  $this->amount.' ر.س',
            'type'    =>  (string) $this->type,
            'details'    =>  (string) $this->details,
            'lat'    =>  (string) @$this->playground?->location['lat'],
            'lng'    =>  (string) @$this->playground?->location['lng'],
            'is_subscribed'    =>  $this->subscribers()->where('subscribers.user_id',auth('api')->id())->where('subscribers.status',SubscriberStatus::IN_PROGRESS)->exists(),
            'is_owner'    =>  $this->when($this->type == MatchType::GROUP && $this->user_id == auth('api')->id(),true,false),
            'is_completed'    =>  ($this->type == MatchType::GROUP ? $this->subscriber_lists_count : $this->subscribers_count) >= @$this->subscribers_qty || !is_null($this->user_id),
            'is_pending'    =>  @$this->subscribers()->where('subscribers.user_id',auth('api')->id())->where('subscribers.status',SubscriberStatus::PENDING)->where('subscribers.status','!=',SubscriberStatus::IN_PROGRESS)->count() > 0 || ($this->type == MatchType::GROUP ? is_null($this->user_id) : false),
            'flagged'    =>  (Carbon::parse($this->date)->format('Y-m-d').' '.Carbon::parse($this->start_time)->format('H:i:s')) <= Carbon::now()->format('Y-m-d H:i:s'),
        ];
    }
}
