<?php

namespace Modules\Match\Resources;

use Carbon\Carbon;
use App\Enum\MatchType;
use Modules\Teams\Resources\TeamResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Playground\Resources\LocationMapResource;

class MatcheResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'    =>  $this->id,
            'playground'    =>  (string) $this->playground?->name,
            'playground_location' => $this->playground ? LocationMapResource::make($this->playground?->location) : null,
            'subscribers_count'    =>  $this->when($this->subscribers_count, function () {
                return (string) ($this->subscribers_count . '/' . $this->subscribers_qty);
            }),
            'date'    =>  Carbon::parse($this->date)->translatedFormat('l Y-m-d'),
            'start_time'    =>  Carbon::parse($this->start_time)->translatedFormat('h:i a'),
            'amount'    =>  $this->amount . ' ر.س',
            'is_reserved'    =>  !is_null($this->user_id),
            'is_competitive' => $this->is_competitive,
            'team1' => $this->whenLoaded('team1', function () {
                return $this->team1 ? new TeamResource($this->team1) : null;
            }),
            'team2' => $this->whenLoaded('team2', function () {
                return $this->team2 ? new TeamResource($this->team2) : null;
            }),
        ];
    }
}
