<?php

namespace Modules\Match\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddSubscriber extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'match_id' => 'required|exists:matches,id,deleted_at,NULL',
            'name' => 'required|string|max:250',
            'phone' => 'required|phone:SA|regex:/^05\d{8}$/',
        ];
    }

    protected function prepareForValidation()
    {
        $mobile = (string) convert_to_english($this->input('phone'));
        if($mobile && !str_starts_with($mobile,0)){
            $this->merge([
                'phone' => '0'.$mobile
            ]);
        }
    }
}
