<?php

namespace Modules\Match\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\User\Models\User;

class Subscriber extends Model
{
    protected $table = 'subscribers';
    protected $fillable = [
        'name',
        'phone',
        'user_id',
        'matche_id',
        'status',
        'presence',
        'payment_method',
    ];

    public function match()
    {
        return $this->belongsTo(Matche::class, 'matche_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
