<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('matches', function (Blueprint $table) {
            $table->unsignedBigInteger('team1_id')->nullable()->after('user_id');
            $table->unsignedBigInteger('team2_id')->nullable()->after('team1_id');
            $table->boolean('awards_points')->default(false);
            $table->foreign('team1_id')->references('id')->on('teams')->nullOnDelete();
            $table->foreign('team2_id')->references('id')->on('teams')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('matches', function (Blueprint $table) {
            $table->dropForeign(['team1_id']);
            $table->dropForeign(['team2_id']);
            $table->dropColumn('team1_id');
            $table->dropColumn('team2_id');
        });
    }
};
