<?php

namespace Modules\Match\Controllers;

use App\Enum\SubscriberStatus;
use App\Enum\UserType;
use App\Helpers\ApiResponse;
use App\Http\Requests\Admin\Matches\Store;
use App\Notifications\MatchSubscribeDeleteNotifications;
use App\Notifications\MatchSubscribeNotifications;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Notifications\Notification;
use Illuminate\Validation\ValidationException;
use libphonenumber\MatchType;
use Modules\Common\Controllers\Admin\HelperController;
use Modules\Match\Models\Matche;
use Modules\Match\Models\Subscriber;
use Modules\Playground\Models\Playground;
use Modules\User\Models\User;
use MshMsh\Helpers\ApiResponder;

class AdminController extends HelperController
{
    public function __construct()
    {
        $type = request('type');
        $this->model = new Matche();
        $this->rows = $this->model->where('type',$type)->with('playground');

        $this->title = "Match";
        $this->name = 'matches';
        $this->formRequest = Store::class;
        $this->canShow = true;
        $this->switches['status'] = route('admin.matches.active_status');
        $this->queryParams['type'] = $type;
    }

    public function listBuilder()
    {
        $this->list = [
            'playground_name' => __('playground'),
            'date' => __('date'),
            'start_time' => __('start time'),
            'end_time' => __('end time'),
            'amount' => __('amount'),
        ];
    }

    public function formBuilder()
    {
        $playgrounds = Playground::active()->pluck('name','id');
        $supervisors = User::where('type',UserType::SUPERVISOR)->pluck('name','id');
        $this->inputs = [
            'playground_id' => ['title' => __('playground'),'type'=>'select','values'=>$playgrounds],
            'supervisor_id' => ['title' => __('supervisor'),'type'=>'select','values'=>$supervisors],
            'date' => ['title' => __('date'),'type'=>'date'],
            'start_time' => ['title' => __('time'),'type'=>'time'],
            'subscribers_qty' => ['title' => __('subscribers count'),'type'=>'number'],
            'durations' => ['title' => __('durations'),'type'=>'number'],
            'durations_text' => ['title' => __('duration text'),'type'=>'text'],
            'details' => ['title' => __('details'),'type'=>'textarea'],
            'amount' => ['title' => __('amount'),'type'=>'number'],
        ];
    }
    public function active_status(Request $request)
    {
        $match = Matche::findOrFail($request->id);
        $match->update(['status' => !$match->status]);
        return ApiResponse::get( '', ['status' => 1]);
    }
    public function show($id)
    {
        $match = Matche::findOrFail($id)->load('subscriber_lists','subscriber_lists.user');
        $title =   __("show match") ;
        $input = [
            "title" => __("users"),
            "name" => "user_id",
            "type" => "ajax_select",
            "action" => route('admin.get_users'),
            "values" => [],
            "empty" => 0
        ];
        $model = new User();
        return view('Match::show', get_defined_vars());

    }

    public function subscribe($id,Request $request)
    {
        $match = Matche::where('id',$id)->active()->inTime()->with('subscribers')->activeSubscribersCount()->first();
        if(!$match){
             return $this->failedfullResponse(__('match is not exist or expired'));
        }
        $user = User::where('id',$request['user_id'])->first();

        if(@$match->subscribers()->where('subscribers.user_id',$user->id)->first()){
            return $this->failedfullResponse(__('this user already subscribed to this match'));
        }
        if($match->subscribers_count >= $match->subscribers_qty){
            $match->subscribers()->syncwithoutdetaching([$user->id => [
                'created_at' => Carbon::now(),
                'status' => SubscriberStatus::PENDING,
            ]
            ]);
        }else{
            $match->subscribers()->syncwithoutdetaching([$user->id => [
                'created_at' => Carbon::now()
            ]
            ]);
        }
        return $this->successfullResponse();
    }
    public function destroy($id)
    {
        $matche = $this->model->findOrFail($id);
        $matche->delete();
        return $this->successfullResponse();
    }

    public function subscribers_destroy($id)
    {
        $subscriber = Subscriber::findOrFail($id);
        $match = $subscriber->match()->withCount(['subscribers'=>fn($q)=>$q->where('subscribers.status',SubscriberStatus::PENDING)])->with('playground')->first();
        \Illuminate\Support\Facades\Notification::send($subscriber->user,new MatchSubscribeDeleteNotifications($match));
        if($match->subscribers_count > 0 && $subscriber->status == SubscriberStatus::IN_PROGRESS){
            $pending_subscriber = $match->subscribers()->where('subscribers.status',SubscriberStatus::PENDING)->first();
            $match->subscribers()->syncwithoutdetaching([$pending_subscriber->id => [
                'status' => SubscriberStatus::IN_PROGRESS,
            ]
            ]);
            \Illuminate\Support\Facades\Notification::send($pending_subscriber,new MatchSubscribeNotifications($match));
        }

        $subscriber->delete();

        return response()->json(['url' => route('admin.matches.show', $match->id), 'message' => __('Info saved successfully')]);
    }
}
