<?php

namespace Modules\Location\Models;

use App\Traits\HasActive;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\User\Models\User;

class Location extends Model
{
    use HasFactory,SoftDeletes,HasActive;
    protected $fillable = [
        'name',
        'status',
    ];
    protected $casts = [
        'status'=>'boolean'
    ];

    public function users()
    {
        return $this->hasMany(User::class);
    }
}
