<?php

namespace Modules\Contactus\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ContactRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|string|max:100',
            'email' => 'nullable|sometimes|email',
            'phone' => 'required|numeric|digits_between:9,13',
            'message' => 'required|string',
        ];
    }
}
