<?php

namespace Modules\Contactus\Models;

use Illuminate\Database\Eloquent\Model;

class Contactus extends Model
{
    protected $table = 'contactus';
    protected $fillable = [
        'type',
        'name',
        'email',
        'phone',
        'message',
        'seen',
        'subject'
    ];
    protected $casts = [
        'created_at' => 'datetime:Y-m-d h:i a'
    ];
    public function scopeUnseen($query)
    {
        return $query->where('seen', null);
    }
}
