<?php

namespace Modules\Contactus\Controllers;

use Modules\Common\Controllers\Admin\HelperController;
use Modules\Contactus\Models\Contactus;

class AdminController extends HelperController
{
    public function __construct()
    {
        $this->model = new Contactus();
        $this->title = "Contact Us";
        $this->name =  'contactus';
        $this->canShow = $this->canDelete = true;
        $this->canAdd = $this->canEdit = false;
        $this->list = ['name' => __('name'),'phone'=>__('phone'),'email'=>__('email'),'created_at'=>__('created at')];
    }

    public function show($id)
    {
        $message = Contactus::findOrFail($id);
        $message->update(['seen' => 1]);
        $title = "Message Details";
        return view('Contactus::admin.show', get_defined_vars());
    }
}
