<?php

namespace Modules\Common\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class ScheduleDayResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request): array
    {
        return [
            'date_text' => $this->format('Y-m-d') == Carbon::now()->format('Y-m-d') ? __("today") : ($this->format('Y-m-d') == Carbon::tomorrow()->format('Y-m-d') ? __('tomorrow') : $this->translatedFormat('l Y-m-d')),
            'date' => $this->format('Y-m-d'),
        ];
    }
}
