<?php

namespace Modules\Common\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\Common\Models\Setting;
use Modules\Orders\Controllers\Api\DateController;
use Modules\Orders\Models\OrderDate;

class SettingsController extends Controller
{
    public function settings()
    {
        if (request()->isMethod('post')) {
            $data = request()->except('_token');
            foreach ($data as $key => $value) {
                if($key == 'logo'){
                    if (is_uploaded_file($value)) {
                        $logo = Setting::firstOrCreate(['key' => $key, 'type' => 'settings']);
                        $logo->clearMediaCollection('logo');
                        $logo->addMedia($value)
                            ->toMediaCollection('logo');
                        $logo->update(['value'=>$logo->getFirstOrDefaultMediaUrl($key)]);
                    }
                }elseif ($key == 'favicon'){
                    if (is_uploaded_file($value)) {
                        $favicon = Setting::firstOrCreate(['key' => $key, 'type' => 'settings']);
                        $favicon->clearMediaCollection('favicon');
                        $favicon->addMedia($value)
                            ->toMediaCollection('favicon');
                        $favicon->update(['value'=>$favicon->getFirstOrDefaultMediaUrl($key)]);
                    }
                }else{
                    Setting::firstOrCreate(['key' => $key, 'type' => 'settings'])->update(['value' => $value]);
                }
            }
            return response()->json(['url' => route('admin.settings.app'), 'message' => 'تم تعديل الإعدادات بنجاح']);
        }
        $inputs = [
            'title' => ['title' => 'عنوان التطبيق', 'setting' => 1],
            'keywords' => ['title' => 'الكلمات الدلالية', 'setting' => 1],
            'banned_day_count' => ['title' => 'أيام الحظر التلقائي','type'=>'number', 'setting' => 1],
            'map_key' => ['title' => __('api map key'),  'setting' => 1],
            'logo' => ['title' => __('logo'), 'type' => 'image','value'=>settings('logo'),'empty'=>1],
            'favicon' => ['title' => __('favicon'), 'type' => 'image','value'=>settings('favicon'),'empty'=>1],
        ];

        $action = route('admin.settings.app');
        $method = 'post';
        $title = __("Settings");
        $model = new Setting;
        return view('Common::admin.form', get_defined_vars());
    }

    public function home()
    {
        if (request()->isMethod('post')) {
            $data = request()->except('_token');
            foreach ($data as $key => $value) {
                Setting::firstOrCreate(['key' => $key, 'type' => 'settings'])->update(['value' => $value]);
            }
            return response()->json(['url' => route('admin.settings.home'), 'message' => 'تم تعديل الإعدادات بنجاح']);
        }
        $inputs = [
            'intro_title' => ['title' => 'عنوان بداية الموقع', 'setting' => 1],
            'intro_sub_title' => ['title' => 'العنوان الفرعي لبداية الموقع', 'setting' => 1],
            'intro_content' => ['title' => 'وصف بداية الموقع', 'setting' => 1],
            'intro_image' => ['title' => 'صورة بداية الموقع', 'type' => 'image', 'setting' => 1]
        ];

        $action = route('admin.settings.home');
        $method = 'post';
        $title = __("Settings");
        $model = new Setting;
        return view('Common::admin.form', get_defined_vars());
    }

    public function app_links()
    {
        if (request()->isMethod('post')) {
            $data = request()->except('_token');
            foreach ($data as $key => $value) {
                Setting::firstOrCreate(['key' => $key, 'type' => 'settings'])->update(['value' => $value]);
            }
            return response()->json(['url' => route('admin.settings.app_links'), 'message' => 'تم تعديل الإعدادات بنجاح']);
        }
        $this->inputs = [
            'android' => ['title' => 'رابط الاندرويد', 'setting' => 1],
            'ios' => ['title' => 'رابط ال IOS', 'setting' => 1],
        ];
        $action = route('admin.settings.app_links');
        $method = 'post';
        $title = __("App Links");
        $model = new Setting;
        return view('Common::admin.form', get_defined_vars());
    }

    public function messages()
    {
        if (request()->isMethod('post')) {
            $data = request()->except('_token');
            foreach ($data as $key => $value) {
                Setting::firstOrCreate(['key' => $key, 'type' => 'messages'])->update(['value' => $value]);
            }
            return response()->json(['url' => route('admin.settings.messages'), 'message' => __("Info saved successfully")]);
        }
        $groups = [
            __("Email") => [
                'mail_mailer' => ['title' => 'نوع المرسل', 'setting' => 1],
                'mail_host' => ['title' => 'Host', 'setting' => 1],
                'mail_port' => ['title' => 'Port', 'setting' => 1],
                'mail_username' => ['title' => 'اسم المستخدم', 'setting' => 1],
                'mail_password' => ['title' => 'كلمة السر', 'setting' => 1],
                'mail_encryption' => ['title' => 'التشفير', 'setting' => 1],
                'mail_from_address' => ['title' => 'بريد المرسل', 'setting' => 1],
                'mail_from_name' => ['title' => 'اسم المرسل', 'setting' => 1],
            ],
            __("SMS") => [
                'sms_username' => ['title' => 'اسم المستخدم', 'setting' => 1],
                'sms_password' => ['title' => 'كلمة السر', 'setting' => 1],
                'sms_sender' => ['title' => 'اسم المرسل', 'setting' => 1],
            ],
        ];
        $action = route('admin.settings.messages');
        $title = __("Message settings");
        $model = new Setting;
        $method = 'post';
        return view('Common::admin.form', get_defined_vars());
    }

    public function contacts()
    {
        if (request()->isMethod('get')) {
            $action = route('admin.settings.contacts');
            $method = 'post';
            $title = __('Contacts');
            $model = new Setting;
            $contacts = Setting::whereType('contacts')->get();
            // dd($contacts);
            return view('Common::admin.settings.contacts', get_defined_vars());
        }
        $keys = array_filter(request('key'));
        $values = request('value');
        $images = request('image');
        foreach ($keys as $i => $key) {
            $setting = Setting::firstOrCreate(['key' => $key, 'type' => 'contacts']);
            $values && isset($values[$i]) && $values[$i] ? $setting->value = ['all' => $values[$i]] : '';
            $images && isset($images[$i]) && $images[$i] ? $setting->image = $images[$i] : '';
            $setting->save();
        }
        return response()->json(['url' => route('admin.settings.contacts'), 'message' => __('Info saved successfully')]);
    }

    public function remove_contact()
    {
        Setting::findOrFail(request('id'))->delete();
        return 'success';
    }

}
