<?php

namespace Modules\Common\Controllers\Admin;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Modules\Contactus\Models\Contactus;
use Modules\Match\Models\Matche;
use Modules\Orders\Models\Order;
use Modules\Playground\Models\Playground;
use Modules\Products\Models\Product;
use Modules\Services\Models\Service;
use Modules\User\Models\User;

class AdminController extends Controller
{
    public function home()
    {
        $title = __("Home page");
        $counters = [
            [
                'title' => __("Users"),
                'url' => route('admin.users.index'),
                'count' => User::count(),
                'icon' => 'fa-users',
                'type' => 'success'
            ],
            [
                'title' => __("Contactus"),
                'url' => route('admin.contactus.index', ['type' => 'message']),
                'count' => Contactus::count(),
                'icon' => 'fa-th-large',
                'type' => 'orange'
            ],
            [
                'title' => __("Playgrounds"),
                'url' => route('admin.playgrounds.index', ['type' => 'message']),
                'count' => Playground::count(),
                'icon' => 'fa-th-large',
                'type' => 'primary'
            ],
            [
                'title' => __("Matches"),
                'url' => route('admin.matches.index', ['type' => 'message']),
                'count' => Matche::whereDate('date','>=',Carbon::now())->count(),
                'icon' => 'fa-th-large',
                'type' => 'primary'
            ]
        ];
        $users = User::latest()->take(10)->get();

        return view('Common::admin.home', get_defined_vars());
    }

    public function getUsers(){
        $name = request('term.term');

        $users = User::where('name', 'like', "%{$name}%")->get();
        $options = [];
        foreach ($users as $user) {
            $options[] = [
                'id' => $user->id,
                'name' => $user->mobile . ' - ' . $user->name,
            ];
        }
        return response()->json($options);
    }

    public function load()
    {
        $title = "";
        return view('Common::admin.load', get_defined_vars());
    }
}
