@extends('Common::admin.layout.page')
@section('page')
    <form action="{{ $action }}" method="post" enctype="multipart/form-data" class="action_form" novalidate>
        @foreach (request()->query() as $key => $val)
            <input type="hidden" name="{{ $key }}" value="{{ $val }}">
        @endforeach
        @if ($method == 'put')
            {{ method_field('put') }}
        @endif
        @csrf

        @php $title = __($title).' [ '.($method == 'post' ? __('Add') : __('Edit')).' ]'; @endphp
{{--            @if($model->status == \App\Enum\CoachingRequest::PENDING)--}}
            @include('Common::admin.form.inputs')
{{--            @else--}}
{{--                <p class="lead text-center">--}}
{{--                    {{__($model->status)}}--}}
{{--                </p>--}}
{{--            @endif--}}
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">
                        {{ __('user details') }}
                    </h3>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-stripped">
                        <tbody>
                        <tr>
                            <th>{{ __('name') }}</th>
                            <td>{{ @$user->name }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('mobile') }}</th>
                            <td>{{ @$user->mobile }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('Email') }}</th>
                            <td>{{ @$user->email }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('Location in playground') }}</th>
                            <td>{{ @$user->location?->name }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('Profile Image') }}</th>
                            <td>
                                @if (@$user->image)
                                    <a href="{{ @$user->image }}" target="_blank" style="font-size:13px">عرض المرفق</a>
                                @endif
                                <!-- use thumbnails -->
                                <img class="img-thumbnail" src="{{ @$user->image }}" width="200" height="150" alt="" />
                            </td>
                        </tr>
                        <tr>
                            <th>{{ __('is blocked') }}</th>
                            <td>{{ @$user->banned ? __('Yes') : __('No') }}</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>



        <div class="col-sm-12">
            <div class="card">
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary"> <span>{{ __('Save') }}</span>
                        <i class="fas fa-save"></i></button>
                </div>
            </div>
        </div>
    </form>
    <script>
        $(function (){
            'use strict';
            $('.select2').select2({
                allowClear: true,
                placeholder: function() {
                    console.log($(this).data('placeholder'));
                    $(this).data('placeholder');
                }
            });
        });
    </script>
@stop
