<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coaching_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\Modules\User\Models\User::class)->constrained();
            $table->string('status')->default(\App\Enum\CoachingRequest::PENDING);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coaching_requests');
    }
};
