<?php

namespace Modules\Coaching\Controllers;

use App\Enum\UserType;
use App\Notifications\Couching\AcceptedNotifications;
use App\Notifications\Couching\RefusedNotifications;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use Modules\Coaching\Models\CoachingRequest;
use Modules\Common\Controllers\Admin\HelperController;

class AdminController extends HelperController
{
    public $user;
    public function __construct()
    {
        $this->model = new CoachingRequest();
        $this->rows = $this->model->with(['user'=>fn($q)=>$q->withTrashed()]);
        $this->title = "Coaching";
        $this->name = 'coaching';
        $this->canAdd = false;
        $this->list = ['user_name' => __('name'),'user_mobile' => __('mobile'),'status' => __('status')];
    }

    public function formBuilder()
    {
        $this->inputs = [
            'status' => ['title' => __('status'),'type'=>'select','values'=>\App\Enum\CoachingRequest::getStatuses()],
        ];
    }
    public function edit($id)
    {
        $this->model = $this->model->findOrFail($id);
        $this->formBuilder();
        $this->user = $this->model->user()->withTrashed()->first();
        $this->method = 'put';
        $this->action = route("admin." . $this->name . ".update", $id);

        return view('Coaching::admin.form', get_object_vars($this));
    }


    public function update(Request $request, $id)
    {
        $data = $this->formRequest ? app($this->formRequest)->validated() : $request->all();
        $this->model = $this->model->findOrFail($id);
        $this->model->update($data);
        $user = $this->model->user;
        if($data['status'] == \App\Enum\CoachingRequest::ACCEPTED){
            $user->update([
                'type' => UserType::COACH
            ]);
            Notification::send($user,new AcceptedNotifications());
        }elseif($data['status'] == \App\Enum\CoachingRequest::REFUSED){
            Notification::send($user,new RefusedNotifications());
        }
        return $this->successfullResponse();
    }

}
