<?php

use Illuminate\Support\Facades\Route;
use Modules\Challenges\Controllers\AdminController;

Route::group(['prefix' => 'admin', 'middleware' => ['web', 'auth', 'admin']], function () {
    Route::get('challenges', [AdminController::class, 'index'])->name('admin.challenges.index');
    Route::get('challenges/create', [AdminController::class, 'create'])->name('admin.challenges.create');
    Route::post('challenges', [AdminController::class, 'store'])->name('admin.challenges.store');
    Route::get('challenges/{id}', [AdminController::class, 'show'])->name('admin.challenges.show');
    Route::get('challenges/{id}/edit', [AdminController::class, 'edit'])->name('admin.challenges.edit');
    Route::put('challenges/{id}', [AdminController::class, 'update'])->name('admin.challenges.update');
    Route::delete('challenges/{id}', [AdminController::class, 'destroy'])->name('admin.challenges.destroy');
    Route::get('challenges/{id}/results', [AdminController::class, 'results'])->name('admin.challenges.results');
    Route::post('challenges/{id}/results', [AdminController::class, 'updateResults'])->name('admin.challenges.updateResults');
});
