@extends('Common::admin.layout.page')

@section('page')
<div class="row">
    <div class="col-sm-12">
        <div class="card card-primary">
            <div class="card-header">
                <h3 class="card-title">{{ __('challenges.Challenge Match Details') }}</h3>
                @if ($match->team1 && $match->team2)
                    <a href="{{ route('admin.challenges.results', $match->id) }}"
                        class="btn btn-sm btn-danger float-right ml-2">
                        <i class="fa fa-pencil"></i> {{ __('challenges.Edit Results') }}
                    </a>
                @endif
                <a href="{{ route('admin.challenges.index') }}" class="btn btn-sm btn-secondary float-right ml-2">
                    <i class="fa fa-arrow-left"></i> {{ __('challenges.Back to List') }}
                </a>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-stripped">
                    <tbody>
                        <tr>
                            <th>{{ __('playground') }}</th>
                            <td>{{ $match->playground ? $match->playground->name : '' }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('date') }}</th>
                            <td>{{ $match->date }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('start time') }}</th>
                            <td>{{ $match->start_time }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('end time') }}</th>
                            <td>{{ $match->end_time }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('amount') }}</th>
                            <td>{{ $match->amount }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('details') }}</th>
                            <td>{{ $match->details }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('challenges.Team 1') }}</th>
                            <td>{{ $match->team1 ? $match->team1->name : __('challenges.Not assigned') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('challenges.Team 2') }}</th>
                            <td>{{ $match->team2 ? $match->team2->name : __('challenges.Not assigned') }}</td>
                        </tr>
                        @if ($match->team1 && $match->team2)
                            <tr>
                                <th>{{ __('challenges.Match Results') }}</th>
                                <td>
                                    {{ $match->team1->name }}:
                                    {{ optional($match->teamResults->where('team_id', $match->team1->id)->first())->goals ?? 0 }}
                                    <br>
                                    {{ $match->team2->name }}:
                                    {{ optional($match->teamResults->where('team_id', $match->team2->id)->first())->goals ?? 0 }}
                                </td>
                            </tr>
                        @endif
                        <tr>
                            <th>{{ __('challenges.Match Type') }}</th>
                            <td>{{ $match->is_competitive ? __('challenges.Competitive') : __('challenges.Friendly') }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Team Members and Subscriptions Section -->
        <div class="row mt-4">
            @if ($match->team1)
                <!-- Team 1 Members -->
                <div class="col-lg-6 col-sm-12">
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">{{ $match->team1->name }} - {{ __('challenges.Members') }}</h3>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>{{ __('Name') }}</th>
                                        <th>{{ __('Phone') }}</th>
                                        <th>{{ __('challenges.Status') }}</th>
                                        <th>{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($team1Members as $member)
                                        <tr>
                                            <td>{{ $member->user->name }}</td>
                                            <td>{{ $member->user->mobile ?? 'N/A' }}</td>
                                            <td>
                                                <span
                                                    class="badge badge-{{ $member->subscriber ? ($member->subscriber->status === 'pending' ? 'warning' : 'success') : 'danger' }}">
                                                    {{ $member->subscriber ? ucfirst($member->subscriber->status) : __('Not Subscribed') }}
                                                </span>
                                            </td>
                                            <td>
                                                <form action="{{ route('admin.challenges.toggle-subscription') }}" method="POST"
                                                    style="display: inline;">
                                                    @csrf
                                                    <input type="hidden" name="match_id" value="{{ $match->id }}">
                                                    <input type="hidden" name="user_id" value="{{ $member->user->id }}">
                                                    @if ($member->subscriber)
                                                        <button type="submit" class="btn btn-xs btn-danger" name="action"
                                                            value="unsubscribe">
                                                            {{ __('Unsubscribe') }}
                                                        </button>
                                                    @else
                                                        <button type="submit" class="btn btn-xs btn-success" name="action"
                                                            value="subscribe">
                                                            {{ __('Subscribe') }}
                                                        </button>
                                                    @endif
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="text-center">{{ __('challenges.No members in this team') }}
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endif

            @if($match->team2)
                <!-- Team 2 Members -->
                <div class="col-lg-6 col-sm-12">
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title">{{ $match->team2->name }} - {{ __('challenges.Members') }}</h3>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>{{ __('Name') }}</th>
                                        <th>{{ __('Phone') }}</th>
                                        <th>{{ __('challenges.Status') }}</th>
                                        <th>{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($team2Members as $member)
                                        <tr>
                                            <td>{{ $member->user->name }}</td>
                                            <td>{{ $member->user->mobile ?? 'N/A' }}</td>
                                            <td>
                                                <span
                                                    class="badge badge-{{ $member->subscriber ? ($member->subscriber->status === 'pending' ? 'warning' : 'success') : 'danger' }}">
                                                    {{ $member->subscriber ? ucfirst($member->subscriber->status) : __('Not Subscribed') }}
                                                </span>
                                            </td>
                                            <td>
                                                <form action="{{ route('admin.challenges.toggle-subscription') }}" method="POST"
                                                    style="display: inline;">
                                                    @csrf
                                                    <input type="hidden" name="match_id" value="{{ $match->id }}">
                                                    <input type="hidden" name="user_id" value="{{ $member->user->id }}">
                                                    @if ($member->subscriber)
                                                        <button type="submit" class="btn btn-xs btn-danger" name="action"
                                                            value="unsubscribe">
                                                            {{ __('Unsubscribe') }}
                                                        </button>
                                                    @else
                                                        <button type="submit" class="btn btn-xs btn-success" name="action"
                                                            value="subscribe">
                                                            {{ __('Subscribe') }}
                                                        </button>
                                                    @endif
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="text-center">{{ __('challenges.No members in this team') }}
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
@stop