@extends('Common::admin.layout.page')

@section('page')
    <div class="row">
        <div class="col-sm-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">{{ __('challenges.Match Results') }}</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.challenges.update-results', $match->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ $match->team1 ? $match->team1->name : '' }}</label>
                                    @php
                                        $team1Result = $results->where('team_id', $match->team1->id)->first();
                                        $team1Goals = $team1Result ? $team1Result->goals : 0;
                                    @endphp
                                    <input type="number" name="results[0][goals]" class="form-control"
                                        value="{{ $team1Goals }}" min="0" required>
                                    <input type="hidden" name="results[0][team_id]" value="{{ $match->team1->id }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ $match->team2 ? $match->team2->name : '' }}</label>
                                    @php
                                        $team2Result = $results->where('team_id', $match->team2->id)->first();
                                        $team2Goals = $team2Result ? $team2Result->goals : 0;
                                    @endphp
                                    <input type="number" name="results[1][goals]" class="form-control"
                                        value="{{ $team2Goals }}" min="0" required>
                                    <input type="hidden" name="results[1][team_id]" value="{{ $match->team2->id }}">
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12">
                                <button type="submit"
                                    class="btn btn-primary">{{ __('challenges.Update Results') }}</button>
                            </div>
                        </div>
                    </form>
                    <a href="{{ route('admin.challenges.index') }}" class="btn btn-secondary mt-3">
                        {{ __('challenges.Back to List') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
@stop
