<?php

use Illuminate\Support\Facades\Route;
use Modules\Challenges\Controllers\ApiController;


Route::group([
    'middleware' => ['auth:sanctum', 'auth-check'],
    'prefix' => 'challenge',
    'controller' => ApiController::class
], function () {
    Route::post('/book-match', 'bookMatch');
    Route::post('/withdraw-team-match', 'withdrawTeamFromMatch');
    Route::post('/send-team-match-request', 'sendTeamMatchRequest');
    Route::post('/respond-team-match-request', 'respondToTeamMatchRequest');
    Route::get('/team-match-invites', 'getTeamMatchInvites');
    Route::get('/playground-challenge-matches/{playgroundId}', 'getChallengeAvailableMatches');

    // Team match results
    Route::post('/set-team-match-result', 'setTeamMatchResult');
    Route::get('/get-team-match-results/{id}', 'getTeamMatchResults');

    Route::get('/challenges-overview', 'challengesOverview');
});
