<?php

use Illuminate\Support\Facades\Route;
use Modules\Challenges\Controllers\AdminController;

Route::group([
    'prefix' => 'challenges',
    'as' => 'challenges.',
    'controller' => AdminController::class
], function () {
    Route::get('/ds/getTeams', 'getTeams')->name('get_teams');
    Route::get('/', 'index')->name('index');
    Route::get('/create', 'create')->name('create');
    Route::post('/', 'store')->name('store');
    Route::get('/{id}', 'show')->name('show');
    Route::get('/{id}/edit', 'edit')->name('edit');
    Route::put('/{id}', 'update')->name('update');
    Route::delete('/{id}', 'destroy')->name('destroy');
    Route::get('/{id}/results', 'results')->name('results');
    Route::put('/{id}/results', 'updateResults')->name('update-results');
    Route::post('/toggle-subscription', 'toggleSubscription')->name('toggle-subscription');
    Route::get('/status/{id}', 'active_status')->name('active_status');
});
