<?php

namespace Modules\Challenges\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TeamMatchRequestResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'match_id' => $this->match_id,
            'requester_team_id' => $this->requester_team_id,
            'invited_team_id' => $this->invited_team_id,
            'status' => $this->status,
            'initiated_by' => $this->initiated_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'match' => $this->whenLoaded('match'),
            'requester_team' => $this->whenLoaded('requesterTeam'),
            'invited_team' => $this->whenLoaded('invitedTeam'),
        ];
    }
}
