<?php

namespace Modules\Challenges\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Modules\Challenges\Models\TeamMatchRequest;
use Modules\Teams\Models\TeamUser;
use Modules\Challenges\Enum\TeamMatchRequestInitiator;

class RespondToTeamMatchRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $rules = [
            'request_id' => 'required|integer|exists:team_match_requests,id',
            'action' => 'required|string|in:accept,reject',
        ];

        // If accepting, check if players array is required
        if ($this->input('action') === 'accept') {
            $requestId = $this->input('request_id');
            $teamMatchRequest = TeamMatchRequest::find($requestId);

            // If initiated by REQUESTER (team1 invited), invited team must send players when accepting
            // If initiated by INVITED (team requested to join), players are already stored
            if ($teamMatchRequest && (string)$teamMatchRequest->initiated_by === TeamMatchRequestInitiator::REQUESTER->value) {
                $rules['players'] = 'required|array|min:10';
                $rules['players.*'] = [
                    'required',
                    'exists:users,id,deleted_at,NULL',
                    function ($attribute, $value, $fail) use ($teamMatchRequest) {
                        $invitedTeamId = $teamMatchRequest->invited_team_id;
                        $exists = TeamUser::query()
                            ->where('team_id', $invitedTeamId)
                            ->where('user_id', $value)
                            ->exists();

                        if (!$exists) {
                            $fail("يرجي التاكد من وجود الفرد في الفريق");
                        }
                    },
                ];
            }
        }

        return $rules;
    }
}
