<?php

namespace Modules\Challenges\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\DB;
use Modules\Teams\Models\TeamUser;

class BookMatchRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'team_id' => 'required|exists:teams,id,deleted_at,NULL',
            'match_id' => 'required|exists:matches,id,deleted_at,NULL',
            'is_competitive' => 'required|boolean',
            'players' => 'required|array|min:10',
            'players.*' => [
                'required',
                'exists:users,id,deleted_at,NULL',
                function ($attribute, $value, $fail) {
                    $teamId = $this->input('team_id');
                    $exists = TeamUser::query()
                        ->where('team_id', $teamId)
                        ->where('user_id', $value)
                        ->exists();

                    if (!$exists) {
                        $fail("يرجي التاكد من وجود الفرد في الفريق");
                    }
                },
            ],
        ];
    }
}
