<?php

namespace Modules\Challenges\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\Match\Models\Matche;
use Modules\Teams\Models\Team;

class TeamMatchResult extends Model
{
    protected $table = 'team_match_results';

    protected $fillable = [
        'match_id',
        'team_id',
        'goals',
        'is_competitive'
    ];

    public function match()
    {
        return $this->belongsTo(Matche::class, 'match_id');
    }

    public function team()
    {
        return $this->belongsTo(Team::class, 'team_id');
    }
}
