<?php

namespace Modules\Challenges\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\Teams\Models\Team;
use Modules\Match\Models\Matche;
use Modules\Challenges\Models\TeamMatchResult;

class TeamMatchRequest extends Model
{
    protected $table = 'team_match_requests';

    protected $fillable = [
        'match_id',
        'requester_team_id',
        'invited_team_id',
        'status',
        'initiated_by',
        'invited_team_players'
    ];

    public function match()
    {
        return $this->belongsTo(Matche::class, 'match_id');
    }

    public function requesterTeam()
    {
        return $this->belongsTo(Team::class, 'requester_team_id');
    }

    public function invitedTeam()
    {
        return $this->belongsTo(Team::class, 'invited_team_id');
    }

    public function results()
    {
        return $this->hasMany(TeamMatchResult::class, 'match_id', 'match_id')
            ->whereIn('team_id', [$this->requester_team_id, $this->invited_team_id]);
    }

    protected $casts = [
        'invited_team_players' => 'array',
    ];
}
