<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTeamMatchResultsTable extends Migration
{
    public function up()
    {
        Schema::create('team_match_results', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('match_id');
            $table->unsignedBigInteger('team_id');
            $table->unsignedInteger('goals')->nullable();
            $table->boolean('team_rankings')->default(false);
            $table->timestamps();

            $table->foreign('match_id')->references('id')->on('matches')->onDelete('cascade');
            $table->foreign('team_id')->references('id')->on('teams')->onDelete('cascade');
            $table->unique(['match_id', 'team_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('team_match_results');
    }
}
