<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTeamMatchRequestsTable extends Migration
{
    public function up()
    {
        Schema::create('team_match_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('match_id');
            $table->unsignedBigInteger('requester_team_id');
            $table->unsignedBigInteger('invited_team_id');
            $table->enum('status', ['pending', 'accepted', 'rejected', 'cancelled'])->default('pending');
            $table->enum('initiated_by', ['requester', 'invited']);
            $table->timestamps();

            $table->foreign('match_id')->references('id')->on('matches')->onDelete('cascade');
            $table->foreign('requester_team_id')->references('id')->on('teams')->onDelete('cascade');
            $table->foreign('invited_team_id')->references('id')->on('teams')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('team_match_requests');
    }
}
