<?php

namespace Modules\Areas\Models;

use App\Traits\HasActive;
use Modules\User\Models\User;
use Modules\Teams\Models\Team;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Area extends Model
{
    use HasFactory, HasActive, SoftDeletes;
    protected $fillable = [
        'name',
        'status',
    ];

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function teams()
    {
        return $this->hasMany(Team::class);
    }
}
