<?php

namespace Modules\Areas\Controllers;

use App\Http\Controllers\Controller;
use Modules\Areas\Models\Area;

class WebController extends Controller
{

    public function index()
    {
        $areas = Area::when(request('val'), function ($query, $val) {
            $encoded_word = str_replace('"', "", json_encode($val));
            $encoded_word = addslashes($encoded_word);
            return $query->where('name', 'like', "%$val%")
                ->orWhere('name', 'like', "%$encoded_word%");
        })->get();

        $str = "";
        foreach ($areas as $row) {
            $str .= "<li data-id='{$row->id}'>{$row->name}</li>";
        }
        return $str;
    }

    public function city_areas()
    {
        $areas = Area::where('area_id', request('id'))->get();
        $str = "";
        foreach ($areas as $row) {
            $str .= "<option value='{$row->id}'>{$row->name}</option>";
        }
        return $str;
    }
}
