<?php

namespace Modules\Areas\Controllers;

use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use Modules\Areas\Models\Area;
use Modules\Areas\Resources\CityResource;

class ApiController extends Controller
{
    public function index()
    {
        $areas = Area::active()->get();
        return ApiResponse::loaded([
            'cities' => CityResource::collection($areas)
        ]);
    }
}
