<?php

namespace Modules\Areas\Controllers;

use App\Helpers\ApiResponse;
use App\Http\Requests\Admin\Areas\Store as AreaStore;
use App\Http\Requests\Admin\Cities\Store;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Validator;
use MatanYadaev\EloquentSpatial\Objects\LineString;
use MatanYadaev\EloquentSpatial\Objects\Point;
use MatanYadaev\EloquentSpatial\Objects\Polygon;
use Modules\Areas\Models\Area;
use Modules\Common\Controllers\Admin\HelperController;
use MshMsh\Helpers\ApiResponder;

class AdminController extends HelperController
{
    public function __construct()
    {
        $this->model = new Area;

        $this->title = "Cities";
        $this->formRequest = Store::class;
        $this->name = 'cities';
        $this->list = ['name' => __('name')];

        $this->switches['status'] = route('admin.areas.active_status');
    }

    public function formBuilder(){
        $this->inputs = [
            'name' => ['title' => __('name')],
        ];
    }

    public function destroy($id)
    {
        $model = $this->model->findOrFail($id);
        if($model->users()->exists()){
            return $this->failedfullResponse(__('This area has associated users.'));
        }
        $model->delete();

        return $this->successfullResponse();
    }
    public function active_status(Request $request)
    {
        $area = Area::findOrFail($request->id);
        $area->update(['status' => !$area->status]);
        return ApiResponse::get( '', ['status' => 1]);
    }
}
