@extends('Common::index')
@section('title', __('Reset Password'))

@section('page')
    <main class="registeration_page__ default_page__">
        <div class="container">
            <div class="main_form__ form_wrapper__">
                <figure class="form_image__ figure__ icon__ center">
                    <img class="img-om" src="{{ url('assets/web') }}/images/register/new_password.svg" alt="..." />
                </figure>
                <div class="registeration_page_title_wrapper__ section_head_wrapper center">
                    <h1 class="section_main_title__">@lang('New Password')</h1>
                    <h2 class="section_sub_title__">
                        @lang('Set new password for your account')
                    </h2>
                </div>
                <form method="POST">
                    @csrf
                    <input type="hidden" name="email" value="{{ $email }}">
                    <div class="input_group__">
                        <input class="input__" type="password" required name="password" placeholder="@lang('New Password')" />
                    </div>
                    <div class="input_group__">
                        <input class="input__" type="password" required name="password_confirmation"
                            placeholder="@lang('Password Confirmation')" />
                    </div>

                    <div class="input_group__">
                        <button type="submit" class="button__ submit-button__ full_width__ center">
                            @lang('Change Password')
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </main>


@stop
