<?php

use Illuminate\Support\Facades\Route;
use Modules\User\Controllers\Api\{ApiController, AuthController,};

Route::middleware('api')->group(function () {


    Route::prefix('auth')->group(function () {
        Route::post('signupplaygroundmaster', [AuthController::class, 'signupPlayGroundMaster']);
        Route::post('signupplayer', [AuthController::class, 'signupPlayer']);
        Route::post('login', [AuthController::class, 'login']);
        Route::post('verify-otp', [AuthController::class, 'verifyOtp']);
        Route::post('resend-otp', [AuthController::class, 'resendOtp']);
        Route::post('validate-request', [AuthController::class, 'ValidateRequest']);
        Route::post('forget-password', [AuthController::class, 'forgetPassword']);
        Route::post('reset-password', [AuthController::class, 'resetPassword']);
        Route::post('verify-otp-password', [AuthController::class, 'verifyOtpPassword']);
        Route::middleware('auth:api')->group(function () {
            Route::post('logout', [AuthController::class, 'logout']);
            Route::get('profile', [ApiController::class, 'profile']);
            Route::post('update-notification-settings', [ApiController::class, 'updateNotificationSettings']);
        });
    });



    Route::prefix('user')->group(function () {
        Route::get('index', [ApiController::class, 'index']);
        Route::get('show/{id}', [ApiController::class, 'show']);
        Route::get('deactivite/{id}', [ApiController::class, 'deactivite']);
        Route::get('delete/{id}', [ApiController::class, 'delete']);
    });
});
