<?php

namespace Modules\User\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Categories\Resources\CategoryResource;
use Modules\Location\Resources\LocationResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => (int) $this->id,
            'FirstName' => $this->FirstName,
            'LastName' => $this->LastName,
            'NickName' => $this->NickName,
            'email' => $this->email,
            'phone' => $this->phone,
            'Date_Of_Birth' => substr($this->Date_Of_Birth, 0, 10),
            'image' => $this->image,
            'status' => (bool) $this->status,
            'gender' => $this->gender,
            'balance' => $this->balance,
            'currency' => $this->currency,
            'self_Ranking' => $this->self_Ranking,
            'longitude' => $this->longitude,
            'Nationality' => $this->Nationality,
            'latitude' => $this->latitude,
            'notification_settings' => $this->notification_settings,
            'category' => CategoryResource::make($this->category),
            'location' => LocationResource::make($this->whenLoaded('location')),
            'role' => RoleResource::make($this->whenLoaded('role')),
            'team_side' => $this->whenPivotLoaded('team_matches', function () {
                return $this->pivot->team_side;
            }),
        ];
    }

    private function translate($value)
    {
        return $value ? __($value) : $value;
    }
}
