<?php

namespace Modules\User\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Modules\Areas\Models\Area;
use Modules\Common\Models\Subscribe;
use Modules\Subscribers\Models\Subscriber;
use Modules\User\Models\User;

class ProfileController extends Controller
{
    public function show()
    {
        $user = auth()->user();
        $title = __('Profile');
        return view('User::show', get_defined_vars());
    }

    public function edit($id)
    {
        $user = auth()->user();
        $title = __('Edit Profile');
        $areas = Area::main()->get();
        $first_area = Area::main()->first();
        $cities = $first_area ? $first_area->areas()->get() : [];
        return view("User::edit", get_defined_vars());
    }

    public function update(Request $request, $id)
    {
        $user = auth()->user();
        $data = $request->validate([
            'name' => 'required',
            'email' => 'email:rfc,dns|required|unique:users,email,' . $user->id,
            'mobile' => 'required|unique:users,mobile,' . $user->id,
            'info' => 'nullable|array',
        ]);
        $user->update($data);
        return back()->with('success', __('Profile updated successfully'));
    }

    public function subscribe()
    {
        $user = auth()->user();
        $is = $user->subscriber ? 0 : 1;
        $user->update(['subscriber' => $is]);
        return back();
    }

    public function myorders()
    {
        $user = auth()->user();
        $orders = $user->orders()->latest()->paginate(30);
        $title = __('My orders');
        return view("User::orders", get_defined_vars());
    }

    public function favourites()
    {
        $user = auth()->user();
        $items = $user->likes()->latest()->get();
        $title = __('Favourites');
        return view("User::items", get_defined_vars());
    }


    public function password_change(Request $request)
    {
        if ($request->isMethod('GET')) {
            $title = __('Change Password');
            return view("User::password", get_defined_vars());
        }
        $request->validate([
            'old_password' => 'required',
            'password' => 'required'
        ]);
        $user = auth()->user();
        if (!Hash::check($request->old_password, $user->password)) {
            return back()->with('error', __('Old password not correct'));
        }
        $user->update(['password' => $request->password]);
        return back()->with('success', __('Password change successfully'));
    }

    public function delete_account()
    {
        $user = auth()->user();
        if ($user->orders()->current()->exists()) {
            return back()->with('error', __('You can not delete your account , there is not completed order attached with this account'));
        }
        auth()->logout();
        $user->update([
            'mobile' => 'DEL::' . time() . '::' . $user->mobile,
            'email' => 'DEL::' . time() . '::' . $user->email,
            'password' => null
        ]);
        return redirect()->to('/')->with('success', __('Your account deleted successfully'));
    }
}
