<?php

namespace Modules\Payment\Services;

use App\Services\Services;
use Illuminate\Support\Facades\Session;


class PaymentService extends Services
{
    protected $gatewayManager;

    public function __construct(PaymentGatewayManager $gatewayManager)
    {
        $this->gatewayManager = $gatewayManager;
    }



    public function chargeWallet($amount, $gateway = 'stripe')
    {
        $user = auth("api")->user();

        return $this->gatewayManager->gateway($gateway)->charge($amount, $user);
    }


}
