<?php

use Illuminate\Support\Facades\Route;
use Modules\Payment\Controllers\StripeWebhookController;
use Modules\Payment\Controllers\PaymentController;
use Modules\Payment\Controllers\ConnectController;

// Webhook Route (No Auth)
Route::post('/stripe/webhook', [StripeWebhookController::class, 'handleWebhook']);

// Public Callback Routes (Stripe redirects here)
Route::get('/payment/success', [PaymentController::class, 'success'])->name('payment.success');
Route::get('/payment/cancel', [PaymentController::class, 'cancel'])->name('payment.cancel');

// Connect Onboarding Callbacks
Route::get('/payment/connect/refresh', function () {
    return "Refresh URL hit.";
})->name('api.payment.connect.refresh');
Route::get('/payment/connect/return', function () {
    return "Return URL hit - Account Connected.";
})->name('api.payment.connect.return');

// Protected Routes
Route::middleware('auth:api')->group(function () {
    Route::post('/payment/charge', [PaymentController::class, 'chargeWallet']);
    Route::post('/payment/withdraw', [PaymentController::class, 'withdraw']);

    // Stripe Connect "Money Journey" Test Routes
    Route::post('/payment/connect/onboard', [ConnectController::class, 'onboard']);
    Route::post('/payment/connect/add-platform-funds', [ConnectController::class, 'addPlatformFunds']);
});
