<?php

namespace Modules\Payment\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class WalletDeposit extends Model
{
    use HasFactory;

    protected $fillable = [
        'wallet_id',
        'stripe_payment_id',
        'amount',
        'current_value',
        'status',
        'expires_at'
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'amount' => 'decimal:2',
        'current_value' => 'decimal:2',
    ];

    public function wallet()
    {
        return $this->belongsTo(Wallet::class);
    }
}
