<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallet_deposits', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('wallet_id');
            $table->string('stripe_payment_id')->nullable()->index(); // Nullable for non-Stripe deposits
            $table->decimal('amount', 10, 2); // Original amount
            $table->decimal('current_value', 10, 2); // Remaining balance available for withdrawal/refund
            $table->enum('status', ['active', 'fully_consumed', 'refunded', 'expired'])->default('active');
            $table->timestamp('expires_at')->nullable(); // For Stripe refund limit (usually 180 days)
            $table->timestamps();

            $table->foreign('wallet_id')->references('id')->on('wallets')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallet_deposits');
    }
};
