<?php

namespace Modules\Payment\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Modules\Payment\Services\WalletService;
use Modules\User\Models\User;
use Stripe\Webhook;
use Stripe\Stripe;
use Stripe\PaymentIntent;
use Stripe\BalanceTransaction;
use Stripe\Charge;
use Stripe\Exception\SignatureVerificationException;

class StripeWebhookController extends Controller
{
    public function handleWebhook(Request $request, WalletService $walletService)
    {


        $endpoint_secret = env('STRIPE_WEBHOOK_SECRET');
        $payload = @file_get_contents('php://input');
        $sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
        $event = null;

        try {
            $event = Webhook::constructEvent(
                $payload,
                $sig_header,
                $endpoint_secret
            );
        } catch (\UnexpectedValueException $e) {
            return response()->json(['error' => 'Invalid payload'], 400);
        } catch (\Stripe\Exception\SignatureVerificationException $e) {
            return response()->json(['error' => 'Invalid signature'], 400);
        }

        if ($event->type == 'checkout.session.completed') {

            try {
                $session = $event->data->object;
                $metadata = $session->metadata;
                $userId = $metadata->user_id ?? null;
                $amount = $metadata->amount_paid ?? 0;
                $type = $metadata->transaction_type ?? null;
                $stripeFee = 0;

                if ($userId && $type == 'wallet_topup') {
                    Stripe::setApiKey(env('STRIPE_SECRET'));
                    // Retrieve the PaymentIntent
                    $paymentIntent = PaymentIntent::retrieve($session->payment_intent);

                    // Retrieve the latest charge
                    $chargeId = $paymentIntent->latest_charge;
                    $charge = Charge::retrieve($chargeId);

                    // Retrieve the balance transaction
                    $balanceTransactionId = $charge->balance_transaction;
                    $balanceTransaction = BalanceTransaction::retrieve($balanceTransactionId);

                    // Get the fee in the currency's main unit (e.g., dollars, pounds)
                    Log::info("DEBUG STRIPE FEE: Raw Fee: " . $balanceTransaction->fee . " | Raw Amount: " . $balanceTransaction->amount . " | Currency: " . $balanceTransaction->currency . " | TX ID: " . $balanceTransaction->id);
                    $stripeFee = $balanceTransaction->fee / 100;
                    $user = User::find($userId);

                    if ($user) {
                        $walletService->deposit(
                            $user,
                            (float)$amount,
                            'deposit',
                            null,
                            "Stripe Top-up",
                            $stripeFee,
                            $session->payment_intent
                        );
                    } else {
                    }
                }
            } catch (\Exception $e) {
                Log::error("CRITICAL ERROR inside Webhook: " . $e->getMessage());
                Log::error($e->getTraceAsString());
                return response()->json(['error' => $e->getMessage()], 500);
            }
        }

        return response()->json(['status' => 'success']);
    }
}
