<?php

namespace Modules\Payment\Controllers;

use Illuminate\Http\Request;
use Stripe\Stripe;
use Stripe\Checkout\Session;
use App\Http\Controllers\Controller;
use Modules\Payment\Requests\ChargeWalletRequest;
use Modules\Payment\Services\PaymentService;

class PaymentController extends Controller
{

    protected $paymentService;
    protected $walletService;

    public function __construct(PaymentService $paymentService, \Modules\Payment\Services\WalletService $walletService)
    {
        $this->paymentService = $paymentService;
        $this->walletService = $walletService;
    }

    public function chargeWallet(ChargeWalletRequest $request)
    {
        $url = $this->paymentService->chargeWallet($request->amount);
        return response()->json([
            'url' => $url
        ]);
    }

    public function withdraw(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric|min:1',
        ]);

        $user = auth('api')->user();

        try {
            $result = $this->walletService->withdraw($user, $request->amount);

            if (!$result) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Withdrawal failed.',
                    'errors' => $this->walletService->errors()
                ], 400);
            }

            return response()->json([
                'status' => 'success',
                'message' => 'Withdrawal processed successfully.',
                'data' => $result 
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage(),
            ], 400);
        }
    }

    public function success()
    {
        return response()->json(['message' => 'Payment successful! Wallet balance will be updated shortly.']);
    }


    public function cancel()
    {
        return response()->json(['message' => 'Payment cancelled.']);
    }
}
