<?php

namespace Modules\Contactus\Controllers;

use App\Helpers\ApiResponse;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponsee;
use Modules\Common\Models\Setting;
use Modules\Contactus\Models\Contactus;
use Modules\Contactus\Requests\ContactRequest;
use Modules\Contactus\Services\ContactusService;

class ApiController extends Controller
{
    use ApiResponsee;

    protected $contactService;
public function __construct(ContactusService $contactService){
    $this->contactService = $contactService;
}

    public function contactus(ContactRequest $request)
    {
        $contact = $this->contactService->store($request->validated());
      
        if(!$contact){
        
            $errors = $this->contactService->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }
        
        return ApiResponse::created($contact,"success",200);
    }



}
