<?php

namespace App\Notifications;

use App\Notifications\Channels\FcmChannel;
use App\Support\Actions\FCMAction;
use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Notifications\Notification;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class MatchSubscribeNotifications extends Notification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    protected $data;
    public function __construct(protected $match)
    {
        $this->data['title'] = 'لقد تم ضمك لمباراه';
        $this->data['message'] = 'لقد تم ضمك في حجز مباراه من خلال قائمة الانتظار في ملعب '.@$match->playground?->name.' في تمام الساعه '.Carbon::parse($match->start_time)->translatedFormat('h:i A');
        $this->data['type'] = 'match_notification';
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [ 'database', FcmChannel::class];
    }



    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return $this->data;
    }

    public function toFcm($notifiable)
    {
        FCMAction::new($notifiable)->withData($this->data)
            ->withTitle(@$this->data['title'])
            ->withBody(@$this->data['message'])
            ->sendMessage('tokens');
    }
}
